<?php
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php'); // Load WordPress core

if (!is_user_logged_in()) {
    wp_die('Access Denied. Please log in at vohraemart.com');
}

$current_user_id = get_current_user_id();

$order_id = isset($_GET['order']) ? absint($_GET['order']) : 0;
$product_id = isset($_GET['product']) ? absint($_GET['product']) : 0;

if (!$order_id || !$product_id) {
    wp_die('Invalid request.');
}

$order = wc_get_order($order_id);

if (!$order || $order->get_user_id() != $current_user_id) {
    wp_die('You are not allowed to access this download.');
}

// Check if product exists in order
$product_found = false;
foreach ($order->get_items() as $item) {
    if ($item->get_product_id() == $product_id) {
        $product_found = true;
        break;
    }
}

if (!$product_found) {
    wp_die('Product not found in your order.');
}

// Map your product_id to a file ID in Google Drive
$downloads_map = [
    1466 => '1kaJtdfkyXNvJtNYMDji36zQwOaOoYtp7',
    1650 => '1_SlrE0CZBqDn7dKH65jkL9Qw5-r_aFBJ',
    // Add more here
];

if (!isset($downloads_map[$product_id])) {
    wp_die('Download not available.');
}

// Build the Google Drive URL (force direct download)
$file_id = $downloads_map[$product_id];
$download_url = "https://drive.google.com/uc?export=download&id={$file_id}";

// Redirect to download
$file_id = $downloads_map[$product_id];
$download_url = "https://drive.google.com/uc?export=download&id={$file_id}";

// Stream file through PHP proxy
$context = stream_context_create([
    "http" => [
        "method" => "GET",
        "header" => "User-Agent: Mozilla/5.0\r\n"
    ]
]);

$stream = @fopen($download_url, 'rb', false, $context);

if (!$stream) {
    wp_die('File could not be retrieved.');
}

// Optional: set your own filename
$filename = 'Vohra E-Mart - Downloaded Product.zip';

header("Content-Type: application/octet-stream");
header("Content-Disposition: attachment; filename=\"$filename\"");
header("Content-Transfer-Encoding: binary");

// Output the stream
fpassthru($stream);
exit;

?>
